<?php

namespace WeDevs\Wpuf\Pro\Frontend;

/**
 * Pro functionality for frontend account page
 *
 * @since 2.8.2
 */
class Account {

    function __construct() {
        add_filter( 'wpuf_account_sections', [ $this, 'manage_account_sections' ] );
        add_filter( 'wpuf_my_account_tab_links', [ $this, 'manage_account_tab_links' ] );
        add_filter( 'wpuf_account_edit_profile_content', [ $this, 'edit_profile_content' ] );
    }

    /**
     * Show/Hide frontend account section depending on Edit Profile option
     *
     * @return array $sections
     */
    public function manage_account_sections( $sections ) {
        $allow_profile_edit = wpuf_get_option( 'show_edit_profile_menu', 'wpuf_my_account', 'on' );
        if ( $allow_profile_edit != 'on' ) {
            foreach ( $sections as $section => $label ) {
                if ( $section == 'edit-profile' ) {
                    unset( $sections[ $section ] );
                }
            }

            return $sections;
        }

        return $sections;
    }

    /**
     * Show/Hide frontend account section depending on Edit Profile option
     *
     * @return array $sections
     */
    public function manage_account_tab_links( $links ) {
        $allow_profile_edit = wpuf_get_option( 'show_edit_profile_menu', 'wpuf_my_account', 'on' );
        if ( $allow_profile_edit != 'on' ) {
            unset( $links['edit-profile'] );
        }

        return $links;
    }

    /**
     * Display content on frontend account page
     *
     * @return string $content
     */
    public function edit_profile_content( $content ) {
        $edit_profile_form = wpuf_get_option( 'edit_profile_form', 'wpuf_my_account', '-1' );
        if ( $edit_profile_form != '-1' ) {
            $content = do_shortcode( '[wpuf_profile type="profile" id="' . $edit_profile_form . '"]' );
        }

        return $content;
    }

}
